//
//  RVApplicationCommandInterpreting.h
//  CommunicationModule
//
//  Created by Greg Harris on 8/1/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RVApplicationCommands.h"
#import "RVTimeCode.h"

@protocol RVApplicationCommandInterpreting <NSObject>

@optional
- (NSDictionary *) interpretApplicationInfo:(NSDictionary *)params;

- (void) interpretTransportStop:(NSDictionary *)params;
- (void) interpretTransportPlay:(NSDictionary *)params;
- (void) interpretTransportPause:(NSDictionary *)params;
- (void) interpretTransportRewind:(NSDictionary *)params;
- (void) interpretTransportFastForward:(NSDictionary *)params;
- (void) interpretTransportSeek:(NSDictionary *)params;
- (void) interpretTransportStep:(NSDictionary *)params;
/*
 interpretTransportTimecode keys:
	timecode - RVTimeCode object
 */
- (void) interpretTransportTimecode:(NSDictionary *)params;

- (void) interpretCueMedia:(NSDictionary *)params;
- (void) interpretCuePresentation:(NSDictionary *)params;
- (void) interpretCuePlaylistItem:(NSDictionary *)params;
- (void) interpretCueAudio:(NSDictionary *)params;

- (void) interpretClearAll;
- (void) interpretClearBackground;
- (void) interpretClearSlide;
- (void) interpretClearProps;
- (void) interpretClearAudio;
- (void) interpretClearLogo;

- (void) interpretTimelinePlay;
- (void) interpretTimelinePause;
- (void) interpretTimelineReset;

- (void) interpretSlideNext;
- (void) interpretSlidePrevious;
- (void) interpretPlaylistItemNext;
- (void) interpretPlaylistItemPrevious;
- (void) interpretMediaNext;
- (void) interpretMediaPrevious;

- (NSDictionary *) interpretGetCuedMedia:(NSDictionary *)params;
- (NSDictionary *) interpretGetCuedPresentation:(NSDictionary *)params;
- (NSDictionary *) interpretGetCuedPlaylistItem:(NSDictionary *)params;
- (NSDictionary *) interpretGetCuedAudio:(NSDictionary *)params;

- (NSDictionary *) interpretListMedia:(NSDictionary *)params;
- (NSDictionary *) interpretListPresentation:(NSDictionary *)params;
- (NSDictionary *) interpretListPlaylistItem:(NSDictionary *)params;
- (NSDictionary *) interpretListAudio:(NSDictionary *)params;

- (NSDictionary *) interpretQueryMedia:(NSDictionary *)params;

- (void) interpretDMXValuesChanged:(NSDictionary *)params;

- (void) interpretMIDINote:(NSDictionary *)params;
- (void) interpretMIDINotes:(NSDictionary *)params;

- (NSDictionary *) currentApplicationState;

- (void) interpretRawData:(NSDictionary *)params;

@end
